﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// This interface is used on an UserControl-based components that are designed to work both inside
    /// the EHR and inside a WinForm application.  The "Consumer" interfaces basically tell Frameworks
    /// that "Consumer" implementating objects need an specific service.  
    /// </summary>
    /// <remarks>
    /// If your component doesn't implement RemoteConsumer you can still user your component.  Implementing
    /// RemoteConsumer is very common and is essential for communicating with the RPMS server.
    /// </remarks>
    public interface RemoteSessionConsumer
    {
        /// <summary>
        /// This property will be set with the primary RemoteSession that the interface implementer can use for communicating
        /// with the RPMS server.  
        /// </summary>  
        /// <remarks>
        /// If also using a RemoteSessionPool, it's important to realize the if the primary RemoteSession that is set through
        /// this interface is closed then every session in the RemoteSessionPool is also clsoed as well as the broker connection
        /// to RPMS.
        /// </remarks>
        RemoteSession RemoteSession { set; }
    }
}
